/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.GeckoLib;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.network.packet.BlockEntityAnimDataSyncPacket;
import software.bernie.geckolib.network.packet.BlockEntityAnimTriggerPacket;
import software.bernie.geckolib.network.packet.StopTriggeredBlockEntityAnimPacket;
import software.bernie.geckolib.util.RenderUtils;

public interface GeoBlockEntity
extends GeoAnimatable {
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(0L).getData(dataTicket);
    }

    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        class_2586 blockEntity = (class_2586)this;
        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            GeckoLib.LOGGER.error("Attempting to set animation data for BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).setData(dataTicket, data);
        } else {
            class_2338 pos = blockEntity.method_11016();
            GeckoLibNetwork.sendToEntitiesTrackingChunk(new BlockEntityAnimDataSyncPacket<D>(pos, dataTicket, data), (class_3218)level, pos);
        }
    }

    default public void triggerAnim(@Nullable String controllerName, String animName) {
        class_2586 blockEntity = (class_2586)this;
        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            GeckoLib.LOGGER.error("Attempting to trigger an animation for a BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).tryTriggerAnimation(controllerName, animName);
        } else {
            class_2338 pos = blockEntity.method_11016();
            GeckoLibNetwork.sendToEntitiesTrackingChunk(new BlockEntityAnimTriggerPacket(pos, controllerName, animName), (class_3218)level, pos);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(@Nullable String controllerName, @Nullable String animName) {
        class_2586 blockEntity = (class_2586)this;
        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            GeckoLib.LOGGER.error("Attempting to stop a triggered animation for a BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.method_8608()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(0L);
            if (controllerName != null) {
                animatableManager.stopTriggeredAnimation(controllerName, animName);
            } else {
                animatableManager.stopTriggeredAnimation(animName);
            }
        } else {
            class_2338 pos = blockEntity.method_11016();
            GeckoLibNetwork.sendToEntitiesTrackingChunk(new StopTriggeredBlockEntityAnimPacket(pos, controllerName, animName), (class_3218)level, pos);
        }
    }

    @Override
    default public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }
}

